/*
 * Decompiled with CFR 0.152.
 */
package kk;

import java.awt.Color;
import java.awt.geom.Point2D;
import kk.Knoboter;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Salmonelle
extends Knoboter {
    public String currentEnemyName = null;
    public double currentEnemyDistance = 10000.0;
    public double currentEnemyEnergy = 10000.0;
    public double radarTurnAngle = 16.0;
    public int count = 0;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.currentEnemyName = null;
        while (true) {
            if (this.currentEnemyName == null) {
                this.setColors(Color.red, Color.red, Color.green);
                this.turnRadarLeft(360.0);
                this.count = 0;
                continue;
            }
            this.radarTurnAngle = -this.radarTurnAngle;
            this.turnRadarLeft((this.count == 0 ? this.radarTurnAngle / 2.0 : this.radarTurnAngle) + this.getRadarTurnRemaining());
            ++this.count;
            if (this.count <= 8) continue;
            this.currentEnemyName = null;
            this.currentEnemyDistance = 10000.0;
            this.currentEnemyEnergy = this.getEnergy();
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (this.currentEnemyName != null && e.getName().equals(this.currentEnemyName)) {
            this.out.println("RIP: " + this.currentEnemyName + ", suche neues Opfer.");
            this.setColors(Color.red, Color.red, Color.yellow);
            this.currentEnemyName = null;
            this.currentEnemyDistance = 10000.0;
            this.currentEnemyEnergy = this.getEnergy();
        }
    }

    @Override
    public synchronized void maybeTrackRobot(ScannedRobotEvent e, boolean priority) {
        double predictedY;
        double predictedX;
        double absoluteBearingRadians;
        double headingRadians;
        double y;
        double x;
        double enemyDistance;
        double enemyEnergy;
        String enemyName;
        block12: {
            enemyName = e.getName();
            enemyEnergy = e.getEnergy();
            if (this.currentEnemyName == null) {
                this.currentEnemyName = enemyName;
                this.setColors(Color.red, Color.red, Color.red);
                this.out.println("Neues Opfer: " + enemyName);
            } else if (priority && !enemyName.equals(this.currentEnemyName) && enemyEnergy < this.getEnergy()) {
                this.currentEnemyName = enemyName;
                this.out.println("Neues Hauptopfer: " + enemyName);
                this.setColors(Color.red, Color.red, Color.red);
            }
            double enemyBearing = e.getBearing();
            double enemyBearingRadians = e.getBearingRadians();
            enemyDistance = e.getDistance();
            double enemyHeadingRadians = e.getHeadingRadians();
            double enemyVelocity = e.getVelocity();
            x = this.getX();
            y = this.getY();
            headingRadians = this.getHeadingRadians();
            double bulletPower = Math.min(3.0, this.getEnergy());
            absoluteBearingRadians = headingRadians + enemyBearingRadians;
            double enemyX = x + enemyDistance * Math.sin(absoluteBearingRadians);
            double enemyY = y + enemyDistance * Math.cos(absoluteBearingRadians);
            double deltaTime = 0.0;
            double battleFieldHeight = this.getBattleFieldHeight();
            double battleFieldWidth = this.getBattleFieldWidth();
            predictedX = enemyX;
            predictedY = enemyY;
            do {
                double d;
                deltaTime += 1.0;
                if (!(d * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(x, y, predictedX, predictedY))) break block12;
                predictedY += Math.cos(enemyHeadingRadians) * enemyVelocity;
            } while (!((predictedX += Math.sin(enemyHeadingRadians) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0));
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - x, predictedY - y));
        double gunTurnRadians = Utils.normalRelativeAngle((double)(theta - this.getGunHeadingRadians()));
        double radarRightRadians = Utils.normalRelativeAngle((double)(absoluteBearingRadians - this.getRadarHeadingRadians()));
        this.out.println("Robot: " + enemyName);
        this.out.println(" theta             = " + theta);
        if (enemyDistance < 60.0 && this.abs(gunTurnRadians) < 0.2 || enemyDistance < 100.0 && this.abs(gunTurnRadians) < 0.1 || enemyDistance < 250.0 && this.abs(gunTurnRadians) < 0.05 || this.abs(gunTurnRadians) < 0.025) {
            this.out.println(" FIRE!");
            this.smartFire();
        }
        if (enemyName.equals(this.currentEnemyName)) {
            double optimalDistance;
            this.out.println(" gunTurnRadians    = " + gunTurnRadians);
            this.out.println(" radarRightRadians = " + radarRightRadians);
            this.setTurnGunRightRadians(gunTurnRadians);
            this.setTurnRadarRightRadians(radarRightRadians);
            this.currentEnemyDistance = enemyDistance;
            this.currentEnemyEnergy = enemyEnergy;
            double enemyTurnRadians = Utils.normalRelativeAngle((double)(theta - headingRadians));
            double direction = 1.0;
            this.out.println(" enemyTurnRadians  = " + enemyTurnRadians);
            if (enemyTurnRadians > 1.5707963267948966) {
                direction = -1.0;
                this.out.println(" enemyTurnRadians -> " + (enemyTurnRadians -= Math.PI) + ", reverse direction");
            } else if (enemyTurnRadians < -1.5707963267948966) {
                direction = -1.0;
                this.out.println(" enemyTurnRadians -> " + (enemyTurnRadians += Math.PI) + ", reverse direction");
            }
            this.setTurnRightRadians(enemyTurnRadians);
            double d = optimalDistance = this.getEnergy() > this.currentEnemyEnergy ? 40.0 : 140.0;
            if (enemyDistance > optimalDistance) {
                this.setAhead((enemyDistance - 50.0) * direction);
            } else if (enemyDistance < 55.0) {
                this.setBack(5.0 * direction);
            }
        }
    }

    @Override
    public void smartFire() {
        if (this.getGunHeat() == 0.0) {
            this.setFire(Math.min(3.0, this.getEnergy()));
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        String name = e.getName();
        if (this.isTeammate(name)) {
            return;
        }
        if (this.currentEnemyName == null || this.currentEnemyName.equals(e.getName())) {
            this.count = 2;
            this.maybeTrackRobot(e, false);
        } else if (e.getDistance() < this.currentEnemyDistance && e.getEnergy() < this.currentEnemyEnergy) {
            this.count = 2;
        }
        this.maybeTrackRobot(e, true);
    }

    public void onHitRobot(HitRobotEvent e) {
        String name = e.getName();
        double bearing = e.getBearing();
        double energy = e.getEnergy();
        if (name.equals(this.currentEnemyName)) {
            return;
        }
        if (this.isTeammate(name)) {
            return;
        }
        if (bearing > -90.0 && bearing < 90.0) {
            this.back(10.0);
        } else {
            this.ahead(10.0);
        }
        if (this.currentEnemyName == null || this.currentEnemyDistance > 60.0) {
            this.count = 2;
            this.maybeTrackRobot(new ScannedRobotEvent(name, energy, bearing, 0.0, 0.0, 0.0, false), true);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        String name = e.getName();
        double bearing = this.getGunHeading() - this.getHeading();
        double energy = e.getEnergy();
        if (name.equals(this.currentEnemyName)) {
            return;
        }
        if (this.isTeammate(name)) {
            return;
        }
        if (this.currentEnemyName == null && energy < this.getEnergy()) {
            this.count = 2;
            this.maybeTrackRobot(new ScannedRobotEvent(name, energy, bearing, 0.0, 0.0, 0.0, false), true);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        String name = e.getName();
        double bearing = e.getBearing();
        if (name.equals(this.currentEnemyName)) {
            return;
        }
        if (this.isTeammate(name)) {
            return;
        }
        if (this.currentEnemyName == null) {
            this.count = 2;
            this.maybeTrackRobot(new ScannedRobotEvent(name, 100.0, bearing, 0.0, 0.0, 0.0, false), true);
        }
    }

    public void onWin(WinEvent e) {
        this.setColors(Color.yellow, Color.yellow, Color.yellow);
        this.out.println("Gewonnen. :-)");
        this.turnRight(1080.0);
        this.stop();
    }

    @Override
    public double abs(double d) {
        return d < 0.0 ? -d : d;
    }
}

